function Figure5F()
% This script plots the data from Figure 5F.

ADI = [0.027778 0.055322 ; 0.015891 0.034793 ; 0.016699 0.055079];
CR9501 = [0.21698 0.4065 ; 0.19255 0.36351 ; 0.22204 0.4471];
neg = [0.015568 0.015639 ; 0.0090193 0.024879 ; 0.0055647 0.023225];

q = [0 1];
plot(q,neg,'Color',[.7 .7 .7]); hold on;
plot(q,mean(neg,1),'k');
q = q + 1.2;
plot(q,ADI,'Color',[.7 .7 .7]); hold on;
plot(q,mean(ADI,1),'k');
q = q + 1.2;
plot(q,CR9501,'Color',[.7 .7 .7]); hold on;
plot(q,mean(CR9501,1),'k');

xticks([0.5 1.7 2.9]);
xticklabels({'CR9501','ADI-14359','-IgG'});
ylabel('Fraction C3-positive particles')

[h,p] = ttest(CR9501(:,1),CR9501(:,2));
disp(['p-value for CR9501 comparison (C3): ',num2str(p)]);
[h,p] = ttest(ADI(:,1),ADI(:,2));
disp(['p-value for ADI-14359 comparison (C3): ',num2str(p)]);
[h,p] = ttest(neg(:,1),neg(:,2));
disp(['p-value for -IgG comparison (C3): ',num2str(p)]);
clear;

ADI = [0.015895 0.034139 ; 0.015873 0.026768 ; 0.0080549 0.024673];
CR9501 = [0.13207 0.10207 ; 0.12982 0.11985 ; 0.12595 0.10896];
neg = [0.0023453 0.0031466 ; 0.0031061 0.0029371 ; 0.0013667 0.0013394];

figure;
q = [0 1];
plot(q,neg,'Color',[.7 .7 .7]); hold on;
plot(q,mean(neg,1),'k');
q = q + 1.2;
plot(q,ADI,'Color',[.7 .7 .7]); hold on;
plot(q,mean(ADI,1),'k');
q = q + 1.2;
plot(q,CR9501,'Color',[.7 .7 .7]); hold on;
plot(q,mean(CR9501,1),'k');

xticks([0.5 1.7 2.9]);
xticklabels({'CR9501','ADI-14359','-IgG'});
ylabel('Mean mAb:F intensity per particle')

[h,p] = ttest(CR9501(:,1),CR9501(:,2));
disp(['p-value for CR9501 comparison (mAb:F): ',num2str(p)]);
[h,p] = ttest(ADI(:,1),ADI(:,2));
disp(['p-value for AD-14359 comparison (mAb:F): ',num2str(p)]);
[h,p] = ttest(neg(:,1),neg(:,2));
disp(['p-value for -IgG comparison (mAb:F): ',num2str(p)]);